/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.scoreboard;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.scoreboard.NameTagVisibility;
import org.bukkit.scoreboard.Team;

final class CraftTeam
extends CraftScoreboardComponent
implements Team {
    private final PlayerTeam team;

    CraftTeam(CraftScoreboard scoreboard, PlayerTeam team) {
        super(scoreboard);
        this.team = team;
    }

    @Override
    public String getName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.m_5758_();
    }

    @Override
    public String getDisplayName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftChatMessage.fromComponent(this.team.m_83364_());
    }

    @Override
    public void setDisplayName(String displayName) throws IllegalStateException {
        Validate.notNull((Object)displayName, (String)"Display name cannot be null", (Object[])new Object[0]);
        Validate.isTrue((ChatColor.stripColor(displayName).length() <= 128 ? 1 : 0) != 0, (String)("Display name '" + displayName + "' is longer than the limit of 128 characters"), (Object[])new Object[0]);
        CraftScoreboard scoreboard = this.checkState();
        this.team.m_83353_(CraftChatMessage.fromString(displayName)[0]);
    }

    @Override
    public String getPrefix() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftChatMessage.fromComponent(this.team.m_83370_());
    }

    @Override
    public void setPrefix(String prefix) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)prefix, (String)"Prefix cannot be null", (Object[])new Object[0]);
        Validate.isTrue((ChatColor.stripColor(prefix).length() <= 64 ? 1 : 0) != 0, (String)("Prefix '" + prefix + "' is longer than the limit of 64 characters"), (Object[])new Object[0]);
        CraftScoreboard scoreboard = this.checkState();
        this.team.m_83360_(CraftChatMessage.fromStringOrNull(prefix));
    }

    @Override
    public String getSuffix() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftChatMessage.fromComponent(this.team.m_83371_());
    }

    @Override
    public void setSuffix(String suffix) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)suffix, (String)"Suffix cannot be null", (Object[])new Object[0]);
        Validate.isTrue((ChatColor.stripColor(suffix).length() <= 64 ? 1 : 0) != 0, (String)("Suffix '" + suffix + "' is longer than the limit of 64 characters"), (Object[])new Object[0]);
        CraftScoreboard scoreboard = this.checkState();
        this.team.m_83365_(CraftChatMessage.fromStringOrNull(suffix));
    }

    @Override
    public ChatColor getColor() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftChatMessage.getColor(this.team.m_7414_());
    }

    @Override
    public void setColor(ChatColor color) {
        Validate.notNull((Object)((Object)color), (String)"Color cannot be null", (Object[])new Object[0]);
        CraftScoreboard scoreboard = this.checkState();
        this.team.m_83351_(CraftChatMessage.getColor(color));
    }

    @Override
    public boolean allowFriendlyFire() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.m_6260_();
    }

    @Override
    public void setAllowFriendlyFire(boolean enabled) throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        this.team.m_83355_(enabled);
    }

    @Override
    public boolean canSeeFriendlyInvisibles() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.m_6259_();
    }

    @Override
    public void setCanSeeFriendlyInvisibles(boolean enabled) throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        this.team.m_83362_(enabled);
    }

    @Override
    public NameTagVisibility getNameTagVisibility() throws IllegalArgumentException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftTeam.notchToBukkit(this.team.m_7470_());
    }

    @Override
    public void setNameTagVisibility(NameTagVisibility visibility) throws IllegalArgumentException {
        CraftScoreboard scoreboard = this.checkState();
        this.team.m_83346_(CraftTeam.bukkitToNotch(visibility));
    }

    @Override
    public Set<OfflinePlayer> getPlayers() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (String playerName : this.team.m_6809_()) {
            players.add((Object)Bukkit.getOfflinePlayer(playerName));
        }
        return players.build();
    }

    @Override
    public Set<String> getEntries() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (String playerName : this.team.m_6809_()) {
            entries.add((Object)playerName);
        }
        return entries.build();
    }

    @Override
    public int getSize() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.team.m_6809_().size();
    }

    @Override
    public void addPlayer(OfflinePlayer player) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null", (Object[])new Object[0]);
        this.addEntry(player.getName());
    }

    @Override
    public void addEntry(String entry) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null", (Object[])new Object[0]);
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.m_6546_(entry, this.team);
    }

    @Override
    public boolean removePlayer(OfflinePlayer player) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null", (Object[])new Object[0]);
        return this.removeEntry(player.getName());
    }

    @Override
    public boolean removeEntry(String entry) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null", (Object[])new Object[0]);
        CraftScoreboard scoreboard = this.checkState();
        if (!this.team.m_6809_().contains(entry)) {
            return false;
        }
        scoreboard.board.m_6519_(entry, this.team);
        return true;
    }

    @Override
    public boolean hasPlayer(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null", (Object[])new Object[0]);
        return this.hasEntry(player.getName());
    }

    @Override
    public boolean hasEntry(String entry) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)"Entry cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        return this.team.m_6809_().contains(entry);
    }

    @Override
    public void unregister() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.m_83475_(this.team);
    }

    @Override
    public Team.OptionStatus getOption(Team.Option option) throws IllegalStateException {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.m_7470_().ordinal()];
            }
            case DEATH_MESSAGE_VISIBILITY: {
                return Team.OptionStatus.values()[this.team.m_7468_().ordinal()];
            }
            case COLLISION_RULE: {
                return Team.OptionStatus.values()[this.team.m_7156_().ordinal()];
            }
        }
        throw new IllegalArgumentException("Unrecognised option " + option);
    }

    @Override
    public void setOption(Team.Option option, Team.OptionStatus status) throws IllegalStateException {
        this.checkState();
        switch (option) {
            case NAME_TAG_VISIBILITY: {
                this.team.m_83346_(Team.Visibility.values()[status.ordinal()]);
                break;
            }
            case DEATH_MESSAGE_VISIBILITY: {
                this.team.m_83358_(Team.Visibility.values()[status.ordinal()]);
                break;
            }
            case COLLISION_RULE: {
                this.team.m_83344_(Team.CollisionRule.values()[status.ordinal()]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised option " + option);
            }
        }
    }

    public static Team.Visibility bukkitToNotch(NameTagVisibility visibility) {
        switch (visibility) {
            case ALWAYS: {
                return Team.Visibility.ALWAYS;
            }
            case NEVER: {
                return Team.Visibility.NEVER;
            }
            case HIDE_FOR_OTHER_TEAMS: {
                return Team.Visibility.HIDE_FOR_OTHER_TEAMS;
            }
            case HIDE_FOR_OWN_TEAM: {
                return Team.Visibility.HIDE_FOR_OWN_TEAM;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + visibility);
    }

    public static NameTagVisibility notchToBukkit(Team.Visibility visibility) {
        switch (visibility) {
            case ALWAYS: {
                return NameTagVisibility.ALWAYS;
            }
            case NEVER: {
                return NameTagVisibility.NEVER;
            }
            case HIDE_FOR_OTHER_TEAMS: {
                return NameTagVisibility.HIDE_FOR_OTHER_TEAMS;
            }
            case HIDE_FOR_OWN_TEAM: {
                return NameTagVisibility.HIDE_FOR_OWN_TEAM;
            }
        }
        throw new IllegalArgumentException("Unknown visibility level " + visibility);
    }

    @Override
    CraftScoreboard checkState() throws IllegalStateException {
        if (((CraftScoreboard)this.getScoreboard()).board.m_83489_(this.team.m_5758_()) == null) {
            throw new IllegalStateException("Unregistered scoreboard component");
        }
        return this.getScoreboard();
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.team != null ? this.team.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftTeam other = (CraftTeam)obj;
        return this.team == other.team || this.team != null && this.team.equals(other.team);
    }
}

